#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;

varying vec4 fragColor;
#else
in vec3 inVertex;
in vec3 inNormal;

out vec4 fragColor;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;
uniform vec4 inColor;
uniform vec3 specularColor;

uniform vec3 lightSource2;
uniform vec3 lightSource2HV;

uniform float shininess;

void main()
{
	/* bump up the lambert to make things more visible */
	float lambert = max(dot(inNormal, lightSource2), 0.0) * 0.85 + 0.15;
	
	/* red book p. 223 */
	vec3 diffuse = inColor.rgb * lambert;
	vec3 ambient = inColor.rgb * vec3(1.25);

	float specFactor = max(dot(lightSource2HV, inNormal), 0.0);
	vec3 specular = specularColor * pow(specFactor, shininess);
	
	/* red book p. 221 */
	fragColor = vec4(ambient + diffuse + specular, inColor.a);
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
